/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.TerrainShaper;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public final class NoiseBasedChunkGenerator
extends ChunkGenerator {
    public static final Codec<NoiseBasedChunkGenerator> f_64314_ = RecordCodecBuilder.create(p_188643_ -> NoiseBasedChunkGenerator.m_208005_(p_188643_).and(p_188643_.group((App)RegistryOps.m_206832_(Registry.f_194568_).forGetter(p_188716_ -> p_188716_.f_188604_), (App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(p_188711_ -> p_188711_.f_62137_), (App)Codec.LONG.fieldOf("seed").stable().forGetter(p_188690_ -> p_188690_.f_64333_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(p_204585_ -> p_204585_.f_64318_))).apply((Applicative)p_188643_, p_188643_.stable(NoiseBasedChunkGenerator::new)));
    private static final BlockState f_64321_ = Blocks.f_50016_.m_49966_();
    private static final BlockState[] f_158373_ = new BlockState[0];
    protected final BlockState f_64316_;
    private final Registry<NormalNoise.NoiseParameters> f_188604_;
    private final long f_64333_;
    protected final Holder<NoiseGeneratorSettings> f_64318_;
    private final NoiseRouter f_209104_;
    private final Climate.Sampler f_158382_;
    private final SurfaceSystem f_188605_;
    private final Aquifer.FluidPicker f_188607_;

    public NoiseBasedChunkGenerator(Registry<StructureSet> p_209106_, Registry<NormalNoise.NoiseParameters> p_209107_, BiomeSource p_209108_, long p_209109_, Holder<NoiseGeneratorSettings> p_209110_) {
        this(p_209106_, p_209107_, p_209108_, p_209108_, p_209109_, p_209110_);
    }

    private NoiseBasedChunkGenerator(Registry<StructureSet> p_209112_, Registry<NormalNoise.NoiseParameters> p_209113_, BiomeSource p_209114_, BiomeSource p_209115_, long p_209116_, Holder<NoiseGeneratorSettings> p_209117_) {
        super(p_209112_, Optional.empty(), p_209114_, p_209115_, p_209116_);
        this.f_188604_ = p_209113_;
        this.f_64333_ = p_209116_;
        this.f_64318_ = p_209117_;
        NoiseGeneratorSettings $$6 = this.f_64318_.m_203334_();
        this.f_64316_ = $$6.f_64440_();
        NoiseSettings $$7 = $$6.f_64439_();
        this.f_209104_ = $$6.m_209366_(p_209113_, p_209116_);
        this.f_158382_ = new Climate.Sampler(this.f_209104_.f_209384_(), this.f_209104_.f_209385_(), this.f_209104_.f_209386_(), this.f_209104_.f_209387_(), this.f_209104_.f_209388_(), this.f_209104_.f_209389_(), this.f_209104_.f_209395_());
        Aquifer.FluidStatus $$8 = new Aquifer.FluidStatus(-54, Blocks.f_49991_.m_49966_());
        int $$9 = $$6.f_64444_();
        Aquifer.FluidStatus $$10 = new Aquifer.FluidStatus($$9, $$6.f_64441_());
        Aquifer.FluidStatus $$11 = new Aquifer.FluidStatus($$7.f_158688_() - 1, Blocks.f_50016_.m_49966_());
        this.f_188607_ = (p_198228_, p_198229_, p_198230_) -> {
            if (p_198229_ < Math.min(-54, $$9)) {
                return $$8;
            }
            return $$10;
        };
        this.f_188605_ = new SurfaceSystem(p_209113_, this.f_64316_, $$9, p_209116_, $$6.m_188893_());
    }

    @Override
    public CompletableFuture<ChunkAccess> m_196423_(Registry<Biome> p_197005_, Executor p_197006_, Blender p_197007_, StructureFeatureManager p_197008_, ChunkAccess p_197009_) {
        return CompletableFuture.supplyAsync(Util.m_183946_("init_biomes", () -> {
            this.m_204586_(p_197007_, p_197008_, p_197009_);
            return p_197009_;
        }), Util.m_183991_());
    }

    private void m_204586_(Blender p_204587_, StructureFeatureManager p_204588_, ChunkAccess p_204589_) {
        NoiseChunk $$3 = p_204589_.m_207937_(this.f_209104_, () -> new Beardifier(p_204588_, p_204589_), this.f_64318_.m_203334_(), this.f_188607_, p_204587_);
        BiomeResolver $$4 = BelowZeroRetrogen.m_204531_(p_204587_.m_183383_(this.f_62138_), p_204589_);
        p_204589_.m_183442_($$4, $$3.m_209218_(this.f_209104_));
    }

    @VisibleForDebug
    public NoiseRouter m_209149_() {
        return this.f_209104_;
    }

    @Override
    public Climate.Sampler m_183403_() {
        return this.f_158382_;
    }

    @Override
    protected Codec<? extends ChunkGenerator> m_6909_() {
        return f_64314_;
    }

    @Override
    public ChunkGenerator m_6819_(long p_64374_) {
        return new NoiseBasedChunkGenerator((Registry<StructureSet>)this.f_207955_, this.f_188604_, this.f_62137_.m_7206_(p_64374_), p_64374_, this.f_64318_);
    }

    public boolean m_64375_(long p_64376_, ResourceKey<NoiseGeneratorSettings> p_64377_) {
        return this.f_64333_ == p_64376_ && this.f_64318_.m_203565_(p_64377_);
    }

    @Override
    public int m_142647_(int p_158405_, int p_158406_, Heightmap.Types p_158407_, LevelHeightAccessor p_158408_) {
        NoiseSettings $$4 = this.f_64318_.m_203334_().f_64439_();
        int $$5 = Math.max($$4.f_158688_(), p_158408_.m_141937_());
        int $$6 = Math.min($$4.f_158688_() + $$4.f_64508_(), p_158408_.m_151558_());
        int $$7 = Mth.m_14042_($$5, $$4.m_189212_());
        int $$8 = Mth.m_14042_($$6 - $$5, $$4.m_189212_());
        if ($$8 <= 0) {
            return p_158408_.m_141937_();
        }
        return this.m_158413_(p_158405_, p_158406_, null, p_158407_.m_64299_(), $$7, $$8).orElse(p_158408_.m_141937_());
    }

    @Override
    public NoiseColumn m_141914_(int p_158401_, int p_158402_, LevelHeightAccessor p_158403_) {
        NoiseSettings $$3 = this.f_64318_.m_203334_().f_64439_();
        int $$4 = Math.max($$3.f_158688_(), p_158403_.m_141937_());
        int $$5 = Math.min($$3.f_158688_() + $$3.f_64508_(), p_158403_.m_151558_());
        int $$6 = Mth.m_14042_($$4, $$3.m_189212_());
        int $$7 = Mth.m_14042_($$5 - $$4, $$3.m_189212_());
        if ($$7 <= 0) {
            return new NoiseColumn($$4, f_158373_);
        }
        BlockState[] $$8 = new BlockState[$$7 * $$3.m_189212_()];
        this.m_158413_(p_158401_, p_158402_, $$8, null, $$6, $$7);
        return new NoiseColumn($$4, $$8);
    }

    @Override
    public void m_207076_(List<String> p_209128_, BlockPos p_209129_) {
        DecimalFormat $$2 = new DecimalFormat("0.000");
        DensityFunction.SinglePointContext $$3 = new DensityFunction.SinglePointContext(p_209129_.m_123341_(), p_209129_.m_123342_(), p_209129_.m_123343_());
        double $$4 = this.f_209104_.f_209389_().m_207386_($$3);
        p_209128_.add("NoiseRouter T: " + $$2.format(this.f_209104_.f_209384_().m_207386_($$3)) + " H: " + $$2.format(this.f_209104_.f_209385_().m_207386_($$3)) + " C: " + $$2.format(this.f_209104_.f_209386_().m_207386_($$3)) + " E: " + $$2.format(this.f_209104_.f_209387_().m_207386_($$3)) + " D: " + $$2.format(this.f_209104_.f_209388_().m_207386_($$3)) + " W: " + $$2.format($$4) + " PV: " + $$2.format(TerrainShaper.m_187265_((float)$$4)) + " AS: " + $$2.format(this.f_209104_.f_209390_().m_207386_($$3)) + " N: " + $$2.format(this.f_209104_.f_209391_().m_207386_($$3)));
    }

    private OptionalInt m_158413_(int p_158414_, int p_158415_, @Nullable BlockState[] p_158416_, @Nullable Predicate<BlockState> p_158417_, int p_158418_, int p_158419_) {
        NoiseSettings $$6 = this.f_64318_.m_203334_().f_64439_();
        int $$7 = $$6.m_189213_();
        int $$8 = $$6.m_189212_();
        int $$9 = Math.floorDiv(p_158414_, $$7);
        int $$10 = Math.floorDiv(p_158415_, $$7);
        int $$11 = Math.floorMod(p_158414_, $$7);
        int $$12 = Math.floorMod(p_158415_, $$7);
        int $$13 = $$9 * $$7;
        int $$14 = $$10 * $$7;
        double $$15 = (double)$$11 / (double)$$7;
        double $$16 = (double)$$12 / (double)$$7;
        NoiseChunk $$17 = NoiseChunk.m_209194_($$13, $$14, p_158418_, p_158419_, this.f_209104_, this.f_64318_.m_203334_(), this.f_188607_);
        $$17.m_188791_();
        $$17.m_188749_(0);
        for (int $$18 = p_158419_ - 1; $$18 >= 0; --$$18) {
            $$17.m_188810_($$18, 0);
            for (int $$19 = $$8 - 1; $$19 >= 0; --$$19) {
                BlockState $$23;
                int $$20 = (p_158418_ + $$18) * $$8 + $$19;
                double $$21 = (double)$$19 / (double)$$8;
                $$17.m_209191_($$20, $$21);
                $$17.m_209230_(p_158414_, $$15);
                $$17.m_209241_(p_158415_, $$16);
                BlockState $$22 = $$17.m_209247_();
                BlockState blockState = $$23 = $$22 == null ? this.f_64316_ : $$22;
                if (p_158416_ != null) {
                    int $$24 = $$18 * $$8 + $$19;
                    p_158416_[$$24] = $$23;
                }
                if (p_158417_ == null || !p_158417_.test($$23)) continue;
                $$17.m_209248_();
                return OptionalInt.of($$20 + 1);
            }
        }
        $$17.m_209248_();
        return OptionalInt.empty();
    }

    @Override
    public void m_183621_(WorldGenRegion p_188636_, StructureFeatureManager p_188637_, ChunkAccess p_188638_) {
        if (SharedConstants.m_183707_(p_188638_.m_7697_())) {
            return;
        }
        WorldGenerationContext $$3 = new WorldGenerationContext(this, p_188636_);
        NoiseGeneratorSettings $$4 = this.f_64318_.m_203334_();
        NoiseChunk $$5 = p_188638_.m_207937_(this.f_209104_, () -> new Beardifier(p_188637_, p_188638_), $$4, this.f_188607_, Blender.m_190202_(p_188636_));
        this.f_188605_.m_189944_(p_188636_.m_7062_(), p_188636_.m_5962_().m_175515_(Registry.f_122885_), $$4.f_209354_(), $$3, p_188638_, $$5, $$4.f_188871_());
    }

    @Override
    public void m_183516_(WorldGenRegion p_188629_, long p_188630_, BiomeManager p_188631_, StructureFeatureManager p_188632_, ChunkAccess p_188633_, GenerationStep.Carving p_188634_) {
        BiomeManager $$6 = p_188631_.m_186687_((p_209119_, p_209120_, p_209121_) -> this.f_62137_.m_203407_(p_209119_, p_209120_, p_209121_, this.m_183403_()));
        WorldgenRandom $$7 = new WorldgenRandom(new LegacyRandomSource(RandomSupport.m_189328_()));
        int $$8 = 8;
        ChunkPos $$9 = p_188633_.m_7697_();
        NoiseChunk $$10 = p_188633_.m_207937_(this.f_209104_, () -> new Beardifier(p_188632_, p_188633_), this.f_64318_.m_203334_(), this.f_188607_, Blender.m_190202_(p_188629_));
        Aquifer $$11 = $$10.m_188817_();
        CarvingContext $$12 = new CarvingContext(this, p_188629_.m_5962_(), p_188633_.m_183618_(), $$10);
        CarvingMask $$13 = ((ProtoChunk)p_188633_).m_183613_(p_188634_);
        for (int $$14 = -8; $$14 <= 8; ++$$14) {
            for (int $$15 = -8; $$15 <= 8; ++$$15) {
                ChunkPos $$16 = new ChunkPos($$9.f_45578_ + $$14, $$9.f_45579_ + $$15);
                ChunkAccess $$17 = p_188629_.m_6325_($$16.f_45578_, $$16.f_45579_);
                BiomeGenerationSettings $$18 = $$17.m_204344_(() -> this.f_62137_.m_203407_(QuartPos.m_175400_($$16.m_45604_()), 0, QuartPos.m_175400_($$16.m_45605_()), this.m_183403_())).m_203334_().m_47536_();
                Iterable<Holder<ConfiguredWorldCarver<?>>> $$19 = $$18.m_204187_(p_188634_);
                int $$20 = 0;
                for (Holder<ConfiguredWorldCarver<?>> $$21 : $$19) {
                    ConfiguredWorldCarver<?> $$22 = $$21.m_203334_();
                    $$7.m_190068_(p_188630_ + (long)$$20, $$16.f_45578_, $$16.f_45579_);
                    if ($$22.m_159273_($$7)) {
                        $$22.m_190712_($$12, p_188633_, $$6::m_204214_, $$7, $$11, $$16, $$13);
                    }
                    ++$$20;
                }
            }
        }
    }

    @Override
    public CompletableFuture<ChunkAccess> m_183489_(Executor p_188702_, Blender p_188703_, StructureFeatureManager p_188704_, ChunkAccess p_188705_) {
        NoiseSettings $$4 = this.f_64318_.m_203334_().f_64439_();
        LevelHeightAccessor $$5 = p_188705_.m_183618_();
        int $$6 = Math.max($$4.f_158688_(), $$5.m_141937_());
        int $$7 = Math.min($$4.f_158688_() + $$4.f_64508_(), $$5.m_151558_());
        int $$8 = Mth.m_14042_($$6, $$4.m_189212_());
        int $$9 = Mth.m_14042_($$7 - $$6, $$4.m_189212_());
        if ($$9 <= 0) {
            return CompletableFuture.completedFuture(p_188705_);
        }
        int $$10 = p_188705_.m_151564_($$9 * $$4.m_189212_() - 1 + $$6);
        int $$11 = p_188705_.m_151564_($$6);
        HashSet $$12 = Sets.newHashSet();
        for (int $$13 = $$10; $$13 >= $$11; --$$13) {
            LevelChunkSection $$14 = p_188705_.m_183278_($$13);
            $$14.m_62981_();
            $$12.add($$14);
        }
        return CompletableFuture.supplyAsync(Util.m_183946_("wgen_fill_noise", () -> this.m_188662_(p_188703_, p_188704_, p_188705_, $$8, $$9)), Util.m_183991_()).whenCompleteAsync((p_209132_, p_209133_) -> {
            for (LevelChunkSection $$3 : $$12) {
                $$3.m_63006_();
            }
        }, p_188702_);
    }

    private ChunkAccess m_188662_(Blender p_188663_, StructureFeatureManager p_188664_, ChunkAccess p_188665_, int p_188666_, int p_188667_) {
        NoiseGeneratorSettings $$5 = this.f_64318_.m_203334_();
        NoiseChunk $$6 = p_188665_.m_207937_(this.f_209104_, () -> new Beardifier(p_188664_, p_188665_), $$5, this.f_188607_, p_188663_);
        Heightmap $$7 = p_188665_.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap $$8 = p_188665_.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        ChunkPos $$9 = p_188665_.m_7697_();
        int $$10 = $$9.m_45604_();
        int $$11 = $$9.m_45605_();
        Aquifer $$12 = $$6.m_188817_();
        $$6.m_188791_();
        BlockPos.MutableBlockPos $$13 = new BlockPos.MutableBlockPos();
        NoiseSettings $$14 = $$5.f_64439_();
        int $$15 = $$14.m_189213_();
        int $$16 = $$14.m_189212_();
        int $$17 = 16 / $$15;
        int $$18 = 16 / $$15;
        for (int $$19 = 0; $$19 < $$17; ++$$19) {
            $$6.m_188749_($$19);
            for (int $$20 = 0; $$20 < $$18; ++$$20) {
                LevelChunkSection $$21 = p_188665_.m_183278_(p_188665_.m_151559_() - 1);
                for (int $$22 = p_188667_ - 1; $$22 >= 0; --$$22) {
                    $$6.m_188810_($$22, $$20);
                    for (int $$23 = $$16 - 1; $$23 >= 0; --$$23) {
                        int $$24 = (p_188666_ + $$22) * $$16 + $$23;
                        int $$25 = $$24 & 0xF;
                        int $$26 = p_188665_.m_151564_($$24);
                        if (p_188665_.m_151564_($$21.m_63017_()) != $$26) {
                            $$21 = p_188665_.m_183278_($$26);
                        }
                        double $$27 = (double)$$23 / (double)$$16;
                        $$6.m_209191_($$24, $$27);
                        for (int $$28 = 0; $$28 < $$15; ++$$28) {
                            int $$29 = $$10 + $$19 * $$15 + $$28;
                            int $$30 = $$29 & 0xF;
                            double $$31 = (double)$$28 / (double)$$15;
                            $$6.m_209230_($$29, $$31);
                            for (int $$32 = 0; $$32 < $$15; ++$$32) {
                                int $$33 = $$11 + $$20 * $$15 + $$32;
                                int $$34 = $$33 & 0xF;
                                double $$35 = (double)$$32 / (double)$$15;
                                $$6.m_209241_($$33, $$35);
                                BlockState $$36 = $$6.m_209247_();
                                if ($$36 == null) {
                                    $$36 = this.f_64316_;
                                }
                                if (($$36 = this.m_198231_($$6, $$29, $$24, $$33, $$36)) == f_64321_ || SharedConstants.m_183707_(p_188665_.m_7697_())) continue;
                                if ($$36.m_60791_() != 0 && p_188665_ instanceof ProtoChunk) {
                                    $$13.m_122178_($$29, $$24, $$33);
                                    ((ProtoChunk)p_188665_).m_63277_($$13);
                                }
                                $$21.m_62991_($$30, $$25, $$34, $$36, false);
                                $$7.m_64249_($$30, $$24, $$34, $$36);
                                $$8.m_64249_($$30, $$24, $$34, $$36);
                                if (!$$12.m_142203_() || $$36.m_60819_().m_76178_()) continue;
                                $$13.m_122178_($$29, $$24, $$33);
                                p_188665_.m_8113_($$13);
                            }
                        }
                    }
                }
            }
            $$6.m_188804_();
        }
        $$6.m_209248_();
        return p_188665_;
    }

    private BlockState m_198231_(NoiseChunk p_198232_, int p_198233_, int p_198234_, int p_198235_, BlockState p_198236_) {
        return p_198236_;
    }

    @Override
    public int m_6331_() {
        return this.f_64318_.m_203334_().f_64439_().f_64508_();
    }

    @Override
    public int m_6337_() {
        return this.f_64318_.m_203334_().f_64444_();
    }

    @Override
    public int m_142062_() {
        return this.f_64318_.m_203334_().f_64439_().f_158688_();
    }

    @Override
    public void m_6929_(WorldGenRegion p_64379_) {
        if (this.f_64318_.m_203334_().f_64445_()) {
            return;
        }
        ChunkPos $$1 = p_64379_.m_143488_();
        Holder<Biome> $$2 = p_64379_.m_204166_($$1.m_45615_().m_175288_(p_64379_.m_151558_() - 1));
        WorldgenRandom $$3 = new WorldgenRandom(new LegacyRandomSource(RandomSupport.m_189328_()));
        $$3.m_64690_(p_64379_.m_7328_(), $$1.m_45604_(), $$1.m_45605_());
        NaturalSpawner.m_204175_(p_64379_, $$2, $$1, $$3);
    }

    @Deprecated
    public Optional<BlockState> m_188668_(CarvingContext p_188669_, Function<BlockPos, Holder<Biome>> p_188670_, ChunkAccess p_188671_, NoiseChunk p_188672_, BlockPos p_188673_, boolean p_188674_) {
        return this.f_188605_.m_189971_(this.f_64318_.m_203334_().f_188871_(), p_188669_, p_188670_, p_188671_, p_188672_, p_188673_, p_188674_);
    }
}

